package MIME;
# Copyright (C) 1993-94,1997 Noboru Ikuta <noboru@ikuta.ichihara.chiba.jp>
#
# mimew.pl: MIME encoder library Ver.2.02 (1997/12/30)

$main'mimew_version = "2.02";

# CXg[ : @INC ̃fBNgiʏ /usr/local/lib/perljɃRs[ 
#                ĉB 
#
# gp1 : require 'mimew.pl';
#           $from = "From: c  <noboru\@ikuta.ichihara.chiba.jp>";
#           print &mimeencode($from);
#
# gp2 : # UNIXBase64GR[hꍇ 
#           require 'mimew.pl';
#           undef $/;
#           $body = <>;
#           print &bodyencode($body);
#           print &benflush;
#
# &bodyencode($data,$coding):
#   f[^Base64`܂Quoted-Printable`ŃGR[hB 
#   2p[^"qp"܂"b64"w肷邱ƂɂR[fBO` 
#   w邱ƂłB2p[^ȗBase64`ŃG 
#   R[hB 
#   Base64`̃GR[h̏ꍇ́A$foldcol*3/4 oCgPʂŕϊ 
#   ̂ŁAnꂽf[^̂[ȕ̓obt@ɕۑꎟɌĂ΂ 
#   ƂɏBŌɃobt@Ɏcf[^&benflushĂ 
#   Ƃɂ菈obt@NAB 
#   Quoted-Printable`̃GR[h̏ꍇ́AsPʂŕϊ邽߁A 
#   f[^̍ŌɉsꍇAŌ̉š̃f[^ 
#   obt@ɕۑAɌĂ΂ꂽƂɏBŌɃobt@ 
#   Ɏcf[^&benflush("qp")ĂԂƂɂ菈obt@ 
#   NAB 
#
# &benflush($coding):
#   1p[^"b64"܂"qp"w肷邱ƂɂAꂼBase64
#   `܂Quoted-Printable`̃GR[hw肷邱ƂłB 
#   1p[^ɉw肵ȂBase64`ŃGR[hB 
#   Base64̃GR[h̏ꍇA&bodyencodecf[^ 
#   pado͂BQuoted-PrintablȅꍇAsPʂłȂubNP 
#   ʂ&bodyencodeĂԏꍇA&bodyencodecf[^ 
#   obt@ɎcĂ΂B 
#   ̃f[^(1܂͉񂩂ɕ)&bodyencodeɕK1 
#   ĂԕKvB 
#
# &mimeencode($text):
#   1p[^{ꕶ܂ł΁A̕ISO-2022-JP 
#   ϊƁAMIME encoded-word(RFC2047Q)ɕϊBKvɉ 
#   encoded-word̕encoded-word̑Oł̍ssB 
#
#   R[h̎́AsShiftJISEUC݂Ăꍇ 
#   ĊR[h݂̍ɂΉĂBShiftJISEUCǂĂ 
#   fłȂƂ$often_use_kanjiɐݒ肳ĂR[hƔ肷B 
#   ISO-2022-JP̃GXP[vV[PX$jis_in$jis_outɐݒ肷邱 
#   ɂύX\łB 

$often_use_kanji = 'EUC'; # or 'SJIS'
$jis_in  = "\x1b\$B"; # ESC-$-B ( or ESC-$-@ )
$jis_out = "\x1b\(B"; # ESC-(-B ( or ESC-(-J )

# zz : 쌠͕܂񂪁AzzEς͎RƂ܂Bς 
#            zzꍇ́AIWiƈقȂ邱Ƃ𖾋LAIWi 
#            ̃o[Wio[ɉϔŃo[Wio[t` 
#            Ⴆ Ver.2.02-XXXXX ̂悤ȃo[Wio[tĉ 
#            BȂACopyright\͕ύXȂłB 
#
#  : &mimeencodejperl1.X(2oCgΉ[h)ŎgpƁASJIS
#        EUC܂7bit JIS(ISO-2022-JP)ɕϊł܂B 
#        ͂Ɋ܂܂镶7bit JIS(ISO-2022-JP)ASCIÎ݂ł邱 
#        ۏ؂ĂꍇAKoriginal̉płperli܂ 
#        jperl1.4ȏ -Llatin IvVtjœĂB 
#        ȂAPerl5Ήjperl͎ƂȂ̂łǂ̂悤ȓɂȂ 
#        킩܂B 
#
# Q : RFC1468, RFC2045, RFC2047

## MIME base64 At@xbge[uiRFC2045j 
%mime = (
"000000", "A",  "000001", "B",  "000010", "C",  "000011", "D",
"000100", "E",  "000101", "F",  "000110", "G",  "000111", "H",
"001000", "I",  "001001", "J",  "001010", "K",  "001011", "L",
"001100", "M",  "001101", "N",  "001110", "O",  "001111", "P",
"010000", "Q",  "010001", "R",  "010010", "S",  "010011", "T",
"010100", "U",  "010101", "V",  "010110", "W",  "010111", "X",
"011000", "Y",  "011001", "Z",  "011010", "a",  "011011", "b",
"011100", "c",  "011101", "d",  "011110", "e",  "011111", "f",
"100000", "g",  "100001", "h",  "100010", "i",  "100011", "j",
"100100", "k",  "100101", "l",  "100110", "m",  "100111", "n",
"101000", "o",  "101001", "p",  "101010", "q",  "101011", "r",
"101100", "s",  "101101", "t",  "101110", "u",  "101111", "v",
"110000", "w",  "110001", "x",  "110010", "y",  "110011", "z",
"110100", "0",  "110101", "1",  "110110", "2",  "110111", "3",
"111000", "4",  "111001", "5",  "111010", "6",  "111011", "7",
"111100", "8",  "111101", "9",  "111110", "+",  "111111", "/",
);
## JISR[h(byte)encoded-word ̕Ή 
%mimelen = (
 8,30, 10,34, 12,34, 14,38, 16,42,
18,42, 20,46, 22,50, 24,50, 26,54,
28,58, 30,58, 32,62, 34,66, 36,66,
38,70, 40,74, 42,74,
);
## wb_GR[h̍s̒̐ 
$limit=74; ## Ӂ $limit75傫ɐݒ肵Ă͂ȂB 
## {fBbase64GR[h̍s̒̐ 
$foldcol=72; ## Ӂ $foldcol76ȉ4̔{ɐݒ肷邱ƁB 
## {fBQuoted-PrintableGR[h̍s̒̐ 
$qfoldcol=75; ## Ӂ $foldcol76ȉɐݒ肷邱ƁB 
## null bit̑} pad̑}̂߂̃e[u 
@zero = ( "", "00000", "0000", "000", "00", "0" );
@pad  = ( "", "===",   "==",   "=" );
## ASCII, 7bit JIS, Shift-JIS y EUC ̊eXɃ}b`p^[ 
$match_ascii = '\x1b\([BHJ]([\t\x20-\x7e]*)';
$match_jis = '\x1b\$[@B](([\x21-\x7e]{2})*)';
$match_sjis = '([\x81-\x9f\xe0-\xfc][\x40-\x7e\x80-\xfc])+';
$match_euc  = '([\xa1-\xfe]{2})+';
## MIME Part 2(charset=`ISO-2022-JP',encoding=`B')  head  tail
$mime_head = '=?ISO-2022-JP?B?';
$mime_tail = '?=';
## &bodyencode gcf[^pobt@ 
$benbuf = "";
## &bodyencode ̏PʁioCgj 
$bensize = int($foldcol/4)*3;
## &mimeencode interface ##
sub main'mimeencode {
    local($_) = @_;
    s/$match_jis/$jis_in$1/go;
    s/$match_ascii/$jis_out$1/go;
    $kanji = &checkkanji;
    s/$match_sjis/&s2j($&)/geo if ($kanji eq 'SJIS');
    s/$match_euc/&e2j($&)/geo if ($kanji eq 'EUC');
    s/(\x1b[\$\(][BHJ@])+/$1/g;
    1 while s/(\x1b\$[B@][\x21-\x7e]+)\x1b\$[B@]/$1/;
    1 while s/$match_jis/&mimeencode($&,$`,$')/eo;
    s/$match_ascii/$1/go;
    $_;
}
## &bodyencode interface ##
sub main'bodyencode {
    local($_,$coding) = @_;
    if (!defined($coding) || $coding eq "" || $coding eq "b64"){
  $_ = $benbuf . $_;
  local($cut) = int((length)/$bensize)*$bensize;
  $benbuf = substr($_, $cut+$[);
  $_ = substr($_, $[, $cut);
  $_ = &base64encode($_);
  s/.{$foldcol}/$&\n/g;
    }elsif ($coding eq "qp"){
  # $benbuf łȂ΃f[^̍ŏɒǉ 
  $_ = $benbuf . $_;
  # s𐳋K 
  s/\r\n/\n/g;
  s/\r/\n/g;
  # f[^sPʂɕ(Ō̉sȍ~ $benbuf ɕۑ)
  @line = split(/\n/,$_,-1);
  $benbuf = pop(@line);
  local($result) = "";
  foreach (@line){
      $_ = &qpencode($_);
      $result .= $_ . "\n";
  }
  $_ = $result;
    }
    $_;
}
## &benflush interface ##
sub main'benflush {
    local($coding) = @_;
    local($ret) = "";
    if ((!defined($coding) || $coding eq "" || $coding eq "b64")
  && $benbuf ne ""){
        $ret = &base64encode($benbuf) . "\n";
        $benbuf = "";
    }elsif ($coding eq "qp" && $benbuf ne ""){
  $ret = &qpencode($benbuf) . "\n";
  $benbuf = "";
    }
    $ret;
}
## MIME wb_GR[fBO 
sub mimeencode {
    local($_, $befor, $after) = @_;
    local($back, $forw, $blen, $len, $flen, $str);
    $befor = substr($befor, rindex($befor, "\n")+1);
    $after = substr($after, 0, index($after, "\n")-$[);
    $back = " " unless ($befor eq ""
                     || $befor =~ /[ \t\(]$/);
    $forw = " " unless ($after =~ /^\x1b\([BHJ]$/
                     || $after =~ /^\x1b\([BHJ][ \t\)]/);
    $blen = length($befor);
    $flen = length($forw)+length($&)-3 if ($after =~ /^$match_ascii/o);
    $len = length($_);
    return "" if ($len <= 3);
    if ($len > 39 || $blen + $mimelen{$len+3} > $limit){
        if ($limit-$blen < 30){
            $len = 0;
        }else{
            $len = int(($limit-$blen-26)/4)*2+3;
        }
        if ($len >= 5){
            $str = substr($_, 0, $len).$jis_out;
            $str = &base64encode($str);
            $str = $mime_head.$str.$mime_tail;
            $back.$str."\n ".$jis_in.substr($_, $len);
        }else{
            "\n ".$_;
        }
    }else{
        $_ .= $jis_out;
        $_ = &base64encode($_);
        $_ = $back.$mime_head.$_.$mime_tail;
        if ($blen + (length) + $flen > $limit){
            $_."\n ";
        }else{
            $_.$forw;
        }
    }
}
## MIME base64 GR[fBO 
sub base64encode {
    local($_) = @_;
    $_ = unpack("B".((length)<<3), $_);
    $_ .= $zero[(length)%6];
    s/.{6}/$mime{$&}/go;
    $_.$pad[(length)%4];
}
## Quoted-Printable GR[fBO 
sub qpencode {
    local($_) = @_;
    # `=' 16i\ɕϊ 
    s/=/=3D/g;
    # s̃^uƃXy[X16i\ɕϊ 
    s/\t$/=09/;
    s/ $/=20/;
    # 󎚉\(`!'``~')ȊO̕16i\ɕϊ 
    s/([^!-~ \t])/&qphex($1)/ge;
    # 1s$qfoldcolȉɂȂ悤Ƀ\tgs 
    local($folded, $line) = "";
    while (length($_) > $qfoldcol){
  $line = substr($_, 0, $qfoldcol-1);
  if ($line =~ /=$/){
      $line = substr($_, 0, $qfoldcol-2);
      $_ = substr($_, $qfoldcol-2);
  }elsif ($line =~ /=[0-9A-Fa-f]$/){
      $line = substr($_, 0, $qfoldcol-3);
      $_ = substr($_, $qfoldcol-3);
  }else{
      $_ = substr($_, $qfoldcol-1);
  }
  $folded .= $line . "=\n";
    }
    $folded . $_;
}
sub qphex {
    local($_) = @_;
    $_ = '=' . unpack("H2", $_);
    tr/a-f/A-F/;
    $_;
}
## Shift-JIS  EUC ̂ǂ̊R[h܂܂邩`FbN 
sub checkkanji {
    local($sjis,$euc);
    $sjis += length($&) while(/$match_sjis/go);
    $euc  += length($&) while(/$match_euc/go);
    return 'NONE' if ($sjis == 0 && $euc == 0);
    return 'SJIS' if ($sjis > $euc);
    return 'EUC'  if ($sjis < $euc);
    $often_use_kanji;
}
## EUC  7bit JIS ɕϊ 
sub e2j {
    local($_) = @_;
    tr/\xa1-\xfe/\x21-\x7e/;
    $jis_in.$_.$jis_out;
}
## Shift-JIS  7bit JIS ɕϊ 
sub s2j {
    local($string);
    local(@ch) = split(//, $_[0]);
    while(($j1,$j2)=unpack("CC",shift(@ch).shift(@ch))){
        if ($j2 > 0x9e){
            $j1 = (($j1>0x9f ? $j1-0xb1 : $j1-0x71)<<1)+2;
            $j2 -= 0x7e;
        }
        else{
            $j1 = (($j1>0x9f ? $j1-0xb1 : $j1-0x71)<<1)+1;
            $j2 -= ($j2>0x7e ? 0x20 : 0x1f);
        }
        $string .= pack("CC", $j1, $j2);
    }
    $jis_in.$string.$jis_out;
}
1;
